<?php $__env->startSection('title', 'Export'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Datawise Attendance Search</h5>
        </div>

        <div class="card-body">
            <!-- Date Picker for Date Range -->
            <form action="<?php echo e(route('search.attendance')); ?>" method="GET" class="mb-3">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-md-4">
                        <label for="start_date">Start Date:</label>
                        <input type="date" name="start_date" class="form-control" required>
                    </div>
                    <div class="col-md-4">
                        <label for="end_date">End Date:</label>
                        <input type="date" name="end_date" class="form-control" required>
                    </div>
                    <div class="col-md-4">
                        <label></label>
                        <button type="submit" class="btn btn-primary">Search</button>
                    </div>
                </div>
            </form>

          <!-- Display Search Results -->
<?php if(isset($finalAttendances)): ?>
<table class="table">
    <thead>
        <tr>
            <th>ID</th>
            <th>APIKEY</th>
            <th>Device ID</th>
            <th>User ID</th>
            <th>Date Time</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $finalAttendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($attendance['id']); ?></td>
                <td><?php echo e($attendance['api_key']); ?></td>
                <td><?php echo e($attendance['device_id']); ?></td>
                <td><?php echo e($attendance['uid']); ?></td>
                <td><?php echo e($attendance['timestamp']); ?></td>
                
                <td><?php echo e($attendance['type'] == 0 ? 'Check IN' : 'Check Out'); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php endif; ?>


        

    <?php if(isset($finalAttendances)): ?>
    <a href="<?php echo e(route('attendances.exportsearch', ['start_date' => request('start_date'), 'end_date' => request('end_date')])); ?>" class="btn btn-success">Export to Excel</a>
<?php endif; ?>


        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\SHR\resources\views/pages/attendance/export.blade.php ENDPATH**/ ?>