<?php

namespace App\Console;

use App\Console\Commands\AttendanceStore;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        AttendanceStore::class
    ];
  
    protected function schedule(Schedule $schedule): void
    {
       
        $schedule->command('attendance:store')->everyMinute();
        $schedule->command('attendance:send')->everyMinute();
    }



  
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
