<?php $__env->startSection('title', 'User List'); ?>

<?php $__env->startSection('content'); ?>
<h5 class="mb-0">Users List</h5><br>
    <div class="card">
        
        <div class="card-header d-flex justify-content-between align-items-center">
            
            <a class="btn btn-primary btn-sm" href="<?php echo e(route('users.create')); ?>">Add User</a>
            <a class="btn btn-success btn-sm" href="<?php echo e(route('users.export')); ?>">Export Excel</a>
          </div>

          


        <div class="card-body">
            <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <?php echo e($error['msg']); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    </button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>SL</th>
                            <th>Device Id</th>
                            <th>User Id</th>
                            <th>Name</th>
                            <th>Role</th>
                            <th>Password</th>
                            <th>Card No</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__currentLoopData = $all_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($user['device_id']); ?></td>
                                <td><?php echo e($user['userid']); ?></td>
                                <td><?php echo e($user['name']); ?></td>
                                <td><?php echo e($user['role']); ?></td>
                                <td><?php echo e($user['password']); ?></td>
                                <td><?php echo e($user['cardno']); ?></td>
                                <td>
                                    <a class="btn btn-primary btn-sm" href="<?php echo e(route('users.show-single', $user)); ?>">
                                        View</a>

                                    <button type="button" class="btn btn-danger btn-sm" onclick="openDeleteModal(this);"
                                        data-id="user-<?php echo e($user['userid']); ?>">
                                        Delete
                                    </button>

                                    <form method="POST" id="user-<?php echo e($user['userid']); ?>"
                                        action="<?php echo e(route('users.destroy', ['uid' => $user['uid'], 'device_id' => $user['device_id'] ])); ?>" class="d-none">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>

                                    </form>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/SHR/resources/views/pages/users/index.blade.php ENDPATH**/ ?>